package com.javainuse.controllers;

import java.io.IOException;

import com.azure.core.credential.TokenCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.core.credential.TokenRequestContext;

import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@RestController
public class ConsumerControllerClient {

	@RequestMapping(value = "/consume", method = RequestMethod.GET)
	public String getEmployee() throws RestClientException, IOException {
		try {
			// Use the specific managed identity by name
			TokenCredential credential = new ManagedIdentityCredentialBuilder()
					.clientId("68502659-cf25-48df-b7c1-426d9dd36d6e") // Use the client ID of javainuse identity
					.build();

			// Get token (adjust the scope as needed for your API)
			TokenRequestContext tokenRequestContext = new TokenRequestContext();
			tokenRequestContext.addScopes("de01e85d-d818-4efc-8f69-17768d078cb5/.default");

			String token = credential.getToken(tokenRequestContext).block().getToken();
			System.out.println("---Hello----");
			System.out.println(token);
			System.out.println("---Hello----");
			String baseUrl = "https://javainuse-producer-e7bhcffqdaf2bxa5.canadacentral-01.azurewebsites.net/employee";
			RestTemplate restTemplate = new RestTemplate();
			ResponseEntity<String> response = null;

			try {
				response = restTemplate.exchange(baseUrl, HttpMethod.GET, getHeaders(token), String.class);
			} catch (Exception ex) {
				System.out.println("API call error: " + ex);
				return "Error calling API: " + ex.getMessage();
			}

			System.out.println(response.getBody());
			return response.getBody();

		} catch (Exception ex) {
			System.out.println("Token acquisition error: " + ex);
			return "Error getting token: " + ex.getMessage();
		}
	}

	private static HttpEntity<?> getHeaders(String token) throws IOException {
		HttpHeaders headers = new HttpHeaders();
		headers.set("Accept", MediaType.APPLICATION_JSON_VALUE);
		headers.set("Authorization", "Bearer " + token);
		return new HttpEntity<>(headers);
	}
}