import os, time
from azure.ai.agents import AgentsClient
from azure.ai.agents.models import ListSortOrder, BingGroundingTool
from azure.identity import AzureCliCredential
from dotenv import load_dotenv

load_dotenv()

endpoint = os.getenv("AZURE_AI_ENDPOINT")

agents_client = AgentsClient(
    endpoint=endpoint,
    credential=AzureCliCredential()
)

# Try just the connection name without the full path
conn_id = os.getenv("BING_CONNECTION_NAME")

# Initialize agent bing tool and add the connection id
bing = BingGroundingTool(connection_id=conn_id)

model = os.getenv("MODEL_DEPLOYMENT_NAME")

with agents_client:
    agent = agents_client.create_agent(
        model=os.environ["MODEL_DEPLOYMENT_NAME"],
        name="my-agent",
        instructions="You are a helpful agent",
        tools=bing.definitions,
    )

    thread = agents_client.threads.create()
    print(f"Created thread, thread ID: {thread.id}")

    message = agents_client.messages.create(
        thread_id=thread.id, 
        role="user", 
        content="What is the stock price of Microsoft?"
    )
    print(f"Created message, message ID: {message.id}")

    run = agents_client.runs.create(thread_id=thread.id, agent_id=agent.id)
    print(f"Created run, run ID: {run.id}, status: {run.status}")

    while run.status in ["queued", "in_progress", "requires_action"]:
        time.sleep(1)
        run = agents_client.runs.get(thread_id=thread.id, run_id=run.id)
        print(f"Run status: {run.status}")

    print(f"Run completed with status: {run.status}")
    
    if run.status == "failed":
        print(f"Run failed. Error: {run.last_error}")

    messages = agents_client.messages.list(thread_id=thread.id, order=ListSortOrder.ASCENDING)
    print(f"\nMessages in thread:")

    for msg in messages:
        if msg.text_messages:
            last_text = msg.text_messages[-1]
            print(f"{msg.role}: {last_text.text.value}")
        else:
            print(f"{msg.role}: [No text messages]")